using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _4
{
    internal class Program
    {
        public struct T
        {
            public long x;
            public long y;
            public T(long x, long y)
            {
                this.x = x;
                this.y = y;
            }
        }
        static long Or(T a, T b, T c)
        {
            return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        }
        static long Pov(List< T > om)
        {
            long ob = 0;
            int n = om.Count;
            for (int i = 0; i < n; i++)
            {
                int sl = (i + 1) % n;
                ob += om[i].x * om[sl].y;
                ob -= om[i].y * om[sl].x;
            }
            return Math.Abs(ob) / 2;
        }
        static List<T> O(List<T> tacke)
        {
            if (tacke.Count < 3)
                return new List<T>();
            tacke.Sort((a, b) =>
            {
                if (a.x != b.x)
                    return a.x.CompareTo(b.x);
                return a.y.CompareTo(b.y);
            });
            List<T> n = new List<T>();
            foreach (var x in tacke)
            {
                while (n.Count >= 2 && Or(n[n.Count - 2], n[n.Count - 1], x) <= 0)
                    n.RemoveAt(n.Count - 1);
                n.Add(x);
            }
            List<T> v = new List<T>();
            for (int i = tacke.Count - 1; i >= 0; i--)
            {
                var x = tacke[i];
                while (v.Count >= 2 && Or(v[v.Count - 2], v[v.Count - 1], x) <= 0)
                    v.RemoveAt(v.Count - 1);
                v.Add(x);
            }
            v.RemoveAt(v.Count - 1);
            n.RemoveAt(n.Count - 1);
            n.AddRange(v);
            return n;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<T> tacke = new List<T>();
            for (int i = 0; i < n; i++)
            {
                string[] u = Console.ReadLine().Split();
                long x = long.Parse(u[0]);
                long y = long.Parse(u[1]);
                tacke.Add(new T (x, y));
            }
            List<T> om = O(tacke);
            if (om.Count < 3)
            {
                Console.WriteLine(0);
                return;
            }
            long min = long.MaxValue;
            for (int i = 0; i < om.Count; i++)
            {
                List<T> t = new List<T>(tacke);
                t.Remove(om[i]);
                List<T> nom = O(t);
                long P = Pov(nom);
                min = Math.Min(min, P);
            }
            Console.WriteLine(min);
        }
    }
}